/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.entities.instances;

import minecrafttransportsimulator.entities.instances.EntityInventoryContainer;
import minecrafttransportsimulator.jsondefs.JSONPart;
import minecrafttransportsimulator.mcinterface.AWrapperWorld;
import minecrafttransportsimulator.mcinterface.IWrapperItemStack;
import minecrafttransportsimulator.mcinterface.IWrapperNBT;
import minecrafttransportsimulator.mcinterface.InterfaceManager;
import minecrafttransportsimulator.packets.instances.PacketCrafterFuelAdd;
import minecrafttransportsimulator.packets.instances.PacketCrafterTimeSet;

public abstract class AEntityCrafter
extends EntityInventoryContainer {
    public static final int FUEL_ITEM_SLOT = 0;
    protected static final IWrapperItemStack EMPTY_STACK = InterfaceManager.coreInterface.getStackForProperties("NOTHING", 0, 1);
    public int ticksFuelProvides;
    public int ticksLeftOfFuel;
    public int ticksNeededToCraft;
    public int ticksLeftToCraft;
    public double powerToDrawPerTick;
    public final JSONPart.JSONPartInteractable definition;
    private final int[] inputSlots;
    private final int[] outputSlots;

    public AEntityCrafter(AWrapperWorld world, IWrapperNBT data, int maxSlots, JSONPart.JSONPartInteractable definition, int[] inputSlots, int[] outputSlots) {
        super(world, data, maxSlots);
        this.definition = definition;
        this.inputSlots = inputSlots;
        this.outputSlots = outputSlots;
        if (data != null) {
            this.ticksFuelProvides = data.getInteger("ticksFuelProvides");
            this.ticksLeftOfFuel = data.getInteger("ticksLeftOfFuel");
            this.ticksNeededToCraft = data.getInteger("ticksNeededToCraft");
            this.ticksLeftToCraft = data.getInteger("ticksLeftToCraft");
            this.powerToDrawPerTick = data.getDouble("powerToDrawPerTick");
        }
    }

    @Override
    public void update() {
        block13: {
            block10: {
                block11: {
                    block12: {
                        IWrapperItemStack fuelStack;
                        super.update();
                        if (this.ticksLeftToCraft <= 0) break block10;
                        if (!this.world.isClient() && this.ticksLeftOfFuel == 0 && this.definition.crafterType == JSONPart.CrafterComponentType.STANDARD && !(fuelStack = this.getStack(0)).isEmpty()) {
                            this.ticksLeftOfFuel = this.ticksFuelProvides = this.getFuelTime(fuelStack);
                            InterfaceManager.packetInterface.sendToAllClients(new PacketCrafterFuelAdd(this));
                            this.removeFromSlot(0, 1);
                        }
                        if (this.ticksNeededToCraft > 0 && !this.world.isClient()) {
                            boolean foundInput = false;
                            for (int i = 0; i < this.inputSlots.length; ++i) {
                                IWrapperItemStack inputStack = this.getStack(this.inputSlots[i]);
                                if (inputStack.isEmpty()) continue;
                                foundInput = true;
                                break;
                            }
                            if (!foundInput) {
                                this.ticksLeftToCraft = this.ticksNeededToCraft = 0;
                                InterfaceManager.packetInterface.sendToAllClients(new PacketCrafterTimeSet(this));
                            }
                        }
                        if (this.ticksLeftOfFuel <= 0) break block11;
                        --this.ticksLeftOfFuel;
                        if (!this.world.isClient()) break block12;
                        if (this.ticksLeftToCraft > 0) {
                            --this.ticksLeftToCraft;
                        }
                        break block13;
                    }
                    if (--this.ticksLeftToCraft != 0) break block13;
                    for (int i = 0; i < this.inputSlots.length; ++i) {
                        IWrapperItemStack craftingOutput = this.getResultForSlot(this.inputSlots[i]);
                        if (craftingOutput.isEmpty()) continue;
                        this.removeFromSlot(this.inputSlots[i], 1);
                        IWrapperItemStack existingOutput = this.getStack(this.outputSlots[i]);
                        if (existingOutput.isEmpty()) {
                            existingOutput = craftingOutput;
                        } else {
                            existingOutput.add(craftingOutput.getSize());
                        }
                        this.setStack(existingOutput, this.outputSlots[i]);
                    }
                    this.ticksNeededToCraft = 0;
                    this.performPostCraftingOperations();
                    break block13;
                }
                this.ticksFuelProvides = 0;
                break block13;
            }
            if (!this.world.isClient()) {
                for (int i = 0; i < this.inputSlots.length; ++i) {
                    IWrapperItemStack inputStack = this.getStack(this.inputSlots[i]);
                    IWrapperItemStack outputStack = this.getResultForSlot(this.inputSlots[i]);
                    if (outputStack.isEmpty()) continue;
                    this.ticksLeftToCraft = this.ticksNeededToCraft = (int)((float)this.getTimeForItem(inputStack) * 1.0f / this.definition.crafterRate);
                    InterfaceManager.packetInterface.sendToAllClients(new PacketCrafterTimeSet(this));
                }
            }
        }
    }

    public abstract String getFuelName();

    protected abstract int getFuelTime(IWrapperItemStack var1);

    protected abstract IWrapperItemStack getResultForSlot(int var1);

    protected abstract int getTimeForItem(IWrapperItemStack var1);

    protected void performPostCraftingOperations() {
    }

    @Override
    public boolean isStackValid(IWrapperItemStack stackToCheck, int index) {
        if (index == 0) {
            return this.definition.crafterType == JSONPart.CrafterComponentType.STANDARD && this.getFuelTime(stackToCheck) != 0;
        }
        return false;
    }

    @Override
    public IWrapperNBT save(IWrapperNBT data) {
        super.save(data);
        data.setInteger("ticksFuelProvides", this.ticksFuelProvides);
        data.setInteger("ticksLeftOfFuel", this.ticksLeftOfFuel);
        data.setInteger("ticksNeededToCraft", this.ticksNeededToCraft);
        data.setInteger("ticksLeftToCraft", this.ticksLeftToCraft);
        data.setDouble("powerToDrawPerTick", this.powerToDrawPerTick);
        return data;
    }
}

